from distutils.core import setup
import sys,os
from penguintv import subProcess

try:
	from pysqlite2 import dbapi2 as sqlite
except:
	sys.exit("Need pysqlite version 2 or higher (http://pysqlite.org/)")
	
try:
	import pycurl
except:
	sys.exit("Need pycurl (http://pycurl.sourceforge.net/)")
	
try:
	import gtkhtml2
except:
	sys.exit("Need gtkhtml2 python bindings")
	
try:
	import gnome
except:
	sys.exit("Need gnome python bindings")
	
try:
	from xml.sax import saxutils
	test = saxutils.DefaultHandler
except:
	sys.exit("Need python-xml")
	

setup(name = "PenguinTV", 
	version = "1.50",
	description      = 'GNOME-compatible podcast and videoblog reader',
	author           = 'Owen Williams',
	author_email     = 'ywwg@usa.net',
	url              = 'http://penguintv.sourceforge.net',
	license          = 'GPL',
	scripts          = ['PenguinTV'],
	data_files       = [('share/penguintv',		['share/penguintv.glade','share/defaultsubs.opml','share/penguintvicon.png']),
						('share/pixmaps',		['share/penguintvicon.png']),
						('share/applications',	['penguintv.desktop'])],
	#desktop_file     = ['penguintv.desktop.in'],
	#package_dir = {"penguintv" : "src/penguintv"},
	packages = ["penguintv", "penguintv/ptvbittorrent"])

sp = subProcess.subProcess('''GCONF_CONFIG_SOURCE=$(gconftool-2 --get-default-source) gconftool-2 --makefile-install-rule share/penguintv.schema''')
if sp.read() != 0:
	print sp.outdata
	print "There was an error installing the gconf schema"
	sys.exit(1)
else:
	print sp.outdata
	
from penguintv.utils import GlobDirectoryWalker,_mkdir
import os.path

for file in GlobDirectoryWalker("./po", "*.po"):
	locale = os.path.basename(file)
	locale = locale[0:locale.rfind('.')]
	_mkdir(sys.prefix+'/share/locale/'+locale+'/LC_MESSAGES/')
	msgfmt_line = "msgfmt "+file+" -o "+sys.prefix+"/share/locale/"+locale+"/LC_MESSAGES/penguintv.mo"
	print msgfmt_line
	sp = subProcess.subProcess(msgfmt_line)
	if sp.read() != 0:
		print sp.outdata
		print "There was an error installing the PO file for locale "+locale
		sys.exit(1)
	else:
		print sp.outdata
