# Written by Owen Williams
# see LICENSE for license information
import penguintv
import gconf
import gtk



class PreferencesDialog:
	def __init__(self,xml,app):
		self.xml = xml
		self._app = app
		self._window = xml.get_widget("window_preferences")
		for key in dir(self.__class__):
			if key[:3] == 'on_':
				self.xml.signal_connect(key, getattr(self,key))
			
		#init values
		self.layout_changed = False;
		self.firstload=True;

		self.feed_refresh_widget = self.xml.get_widget("feed_refresh")
		self.player_cmdline_widget = self.xml.get_widget("player_cmdline")
		self.player_cmdline_model = self.player_cmdline_widget.get_model()
		self.set_player_cmdline(self._app.get_player_cmdline())
		
		#self.radio_standard = self.xml.get_widget("layout_standard")
		#self.radio_standard.connect("toggled", self.select_layout, "standard")
		#self.radio_widescreen = self.xml.get_widget("layout_widescreen")
		#self.radio_widescreen.connect("toggled", self.select_layout, "widescreen")
		#self.radio_vertical = self.xml.get_widget("layout_vertical")
		#self.radio_vertical.connect("toggled", self.select_layout, "vertical")
		#self.set_app_window_layout(self._app.get_app_window_layout())
		
		self.radio_refresh_spec = self.xml.get_widget("refresh_specified")
		self.radio_refresh_spec.connect("toggled", self.select_refresh, penguintv.REFRESH_SPECIFIED)
		self.radio_refresh_auto = self.xml.get_widget("refresh_auto")
		self.radio_refresh_auto.connect("toggled", self.select_refresh, penguintv.REFRESH_AUTO)
		
		self.min_port_widget = self.xml.get_widget("min_port_entry")
		self.max_port_widget = self.xml.get_widget("max_port_entry")
		self.ul_limit_widget = self.xml.get_widget("upload_limit_entry")
		
		self.autoresume = self.xml.get_widget("auto_resume")
		
		self.auto_download_widget = self.xml.get_widget("auto_download")
		self.auto_download_limiter_widget = self.xml.get_widget("auto_download_limiter")
		self.auto_download_limit_widget = self.xml.get_widget("auto_download_limit")
		self.limiter_hbox_widget = self.xml.get_widget("limiter_hbox")
		
		#gconf setup		
		self.conf =  gconf.client_get_default()
		self.conf.add_dir('/apps/penguintv',gconf.CLIENT_PRELOAD_NONE)
		#self.conf.notify_add('/apps/penguintv/auto_resume',self.gconf_update_auto_resume)
		#self.conf.notify_add('/apps/penguintv/bt_max_port',self.gconf_update_bt_maxport)
		#self.conf.notify_add('/apps/penguintv/bt_min_port',self.gconf_update_bt_minport)
		#self.conf.notify_add('/apps/penguintv/ul_limit',self.gconf_update_bt_ullimit)
		#self.conf.notify_add('/apps/penguintv/feed_refresh_frequency',self.gconf_update_polling_frequency)
		#self.conf.notify_add('/apps/penguintv/player_cmdline',self.gconf_update_player_cmdline)
		#self.conf.notify_add('/apps/penguintv/app_window_layout',self.gconf_update_app_window_layout)
		#self.conf.notify_add('/apps/penguintv/feed_refresh_method',self.gconf_update_feed_refresh_method)
		#self.conf.notify_add('/apps/penguintv/auto_download',self.gconf_update_auto_download)
		#self.conf.notify_add('/apps/penguintv/auto_download_limiter',self.gconf_update_auto_download_limiter)
		#self.conf.notify_add('/apps/penguintv/auto_download_limit',self.gconf_update_auto_download_limit)
				
	def show(self):
		self._window.show()
		
	def hide(self):
		#self.feed_refresh_widget.set_text("")
		#if self.firstload==True:
	#		self.firstload=False
#		else:#
			#try:
		#		if self.layout_changed==True:
				#if False:
#					print "is true"
		#			dialog = gtk.Dialog(title="Must Restart", parent=None, flags=gtk.DIALOG_MODAL, buttons=(gtk.STOCK_OK, 	gtk.RESPONSE_ACCEPT))
		#			label = gtk.Label("You must restart PenguinTV in order to see the new layout.")
	#				dialog.vbox.pack_start(label, True, True, 0)
	#				label.show()
	#				response = dialog.run()
	#				dialog.hide()
	#				del dialog
	#				self.layout_changed=False
	#		except:
	#			pass #fails on load
		self._window.hide()
		
	def set_player_cmdline(self, player_cmdline):
		i=0
		found=0
		
		if player_cmdline is None:
			player_cmdline="totem --enqueue"
		child = self.player_cmdline_model.get_iter_root()
		while child is not None:
			inlist = self.player_cmdline_model.get_value(child,0)
			if inlist == player_cmdline:
				found=1
				break
			if player_cmdline.startswith(inlist):
				self.player_cmdline_model.set_value(child,0,player_cmdline)
				found=1
				break
			if inlist.startswith(player_cmdline):
				self.player_cmdline_model.set_value(child,0,player_cmdline)
				found=1
				break
			child = self.player_cmdline_model.iter_next(child)
			i=i+1
		if found ==1:
			self.player_cmdline_widget.set_active(i)		
		else:
			self.player_cmdline_model.append((player_cmdline,))
			self.player_cmdline_widget.set_active(len(self.player_cmdline_model)-1)		
			
	def set_app_window_layout(self, layout):
		if layout=="standard":
			self.radio_standard.set_active(True)
		elif layout=="widescreen":
			self.radio_widescreen.set_active(True)	
		elif layout=="vertical":
			self.radio_vertical.set_active(True)
		else:
			self.radio_standard.set_active(True)
			
	def set_feed_refresh_method(self, method):
		if method==penguintv.REFRESH_AUTO:
			self.radio_refresh_auto.set_active(True)
		else:
			self.radio_refresh_spec.set_active(True)

	def set_feed_refresh_frequency(self, freq):
		self.feed_refresh_widget.set_text(str(freq))
		
	def set_bt_settings(self, bt_settings):
		self.min_port_widget.set_text(str(bt_settings['min_port']))
		self.max_port_widget.set_text(str(bt_settings['max_port']))		
		self.ul_limit_widget.set_text(str(bt_settings['ul_limit']))			
	#	self.dl_limit_widget.set_text(str(bt_settings['dl_limit']))			
	
	def set_auto_resume(self, autoresume):
		self.autoresume.set_active(autoresume)
		
	def set_auto_download(self, auto_download):
		self.auto_download_widget.set_active(auto_download)
		self.limiter_hbox_widget.set_sensitive(auto_download)
	
	def set_auto_download_limiter(self, limiter):
		self.auto_download_limiter_widget.set_active(limiter)
		
	def set_auto_download_limit(self, limit):
		self.auto_download_limit_widget.set_text(str(limit/1024))
#		print "set text to: "+str(limit/1024)
					
	def on_button_close_clicked(self,event):
		self.hide()
		
	#we just update the gconf keys here, and then the app is signalled and it updates itself

	def on_player_cmdline_changed(self,event):
		try:
			self.conf.set_string('/apps/penguintv/player_cmdline',self.player_cmdline_widget.get_active_text())
		except AttributeError:
			pass #this fails on startup, which is good because we haven't loaded the proper value in the app yet
			
#	def select_layout(self, radiobutton, new_val):
#		self.layout_changed=True
#		try:
#			self.conf.set_string('/apps/penguintv/app_window_layout',new_val)
#		except AttributeError:
#			pass #this fails on startup, which is good because we haven't loaded the proper value in the app yet
	
	def select_refresh(self, radiobutton, new_val):
		try:
			if new_val==penguintv.REFRESH_AUTO:
				self.conf.set_string('/apps/penguintv/feed_refresh_method','auto')
			else:
				self.conf.set_string('/apps/penguintv/feed_refresh_method','specified')
		except AttributeError:
			pass #this fails on startup, which is good because we haven't loaded the proper value in the app yet
	
	def on_feed_refresh_changed(self,event):
		try:
			val = int(self.feed_refresh_widget.get_text())
		except ValueError:
			return
		self.conf.set_int('/apps/penguintv/feed_refresh_frequency',val)
		
	def on_auto_resume_toggled(self,event):
		self.conf.set_bool('/apps/penguintv/auto_resume',self.autoresume.get_active())
		
	def on_auto_download_toggled(self, event):
		self.conf.set_bool('/apps/penguintv/auto_download',self.auto_download_widget.get_active())
		
	def on_auto_download_limiter_toggled(self,event):
		self.conf.set_bool('/apps/penguintv/auto_download_limiter',self.auto_download_limiter_widget.get_active())
		
	def on_auto_download_limit_focus_out_event(self, thing, event):
		try:
			limit = int(self.auto_download_limit_widget.get_text())*1024
#			print "from prefs, setting gconf to, "+str(limit)
		except ValueError:
			return
		self.conf.set_int('/apps/penguintv/auto_download_limit',limit)
		
	def on_min_port_entry_changed(self,event):
		try:
			minport = int(self.min_port_widget.get_text())
		except ValueError:
			return
		self.conf.set_int('/apps/penguintv/bt_min_port',minport)
		
	def on_max_port_entry_changed(self,event):
		try:
			maxport = int(self.max_port_widget.get_text())
		except ValueError:
			return
		self.conf.set_int('/apps/penguintv/bt_max_port',maxport)
		
	def on_upload_limit_entry_changed(self,event):
		try:
			val = int(self.ul_limit_widget.get_text())
		except ValueError:
			return
		self.conf.set_int('/apps/penguintv/bt_ul_limit',val)
		
	#also, watch for gconf changes so that we can update the UI correctly
		
#	def gconf_update_auto_resume(self, client, *args, **kwargs):
#		auto_resume = self.conf.get_bool('/apps/penguintv/auto_resume')
#		self.autoresume.set_active(auto_resume)
#		
#	def gconf_update_bt_maxport(self, client, *args, **kwargs):
#		maxport = self.conf.get_int('/apps/penguintv/bt_max_port')
#		self.max_port_widget.set_text(str(maxport))
#		
#	def gconf_update_bt_minport(self, client, *args, **kwargs):
#		minport = self.conf.get_int('/apps/penguintv/bt_min_port')
#		self.min_port_widget.set_text(str(minport))
#		
#	def gconf_update_bt_ullimit(self, client, *args, **kwargs):
#		ullimit = self.conf.get_int('/apps/penguintv/ul_limit')
#		self.ul_limit_widget.set_text(str(ullimit))
#		
#	def gconf_update_polling_frequency(self, client, *args, **kwargs):
#		freq = self.conf.get_int('/apps/penguintv/feed_refresh_frequency')
#		self.feed_refresh_widget.set_text(str(freq))
#		
#	def gconf_update_player_cmdline(self, client, *args, **kwargs):
#		cmdline = self.conf.get_string('/apps/penguintv/player_cmdline')
#		self.set_player_cmdline(cmdline)
		
#	def gconf_update_app_window_layout(self, client, *args, **kwargs):
#		layout = self.conf.get_string('/apps/penguintv/app_window_layout')
#		self.set_app_window_layout(layout)
		
#	def gconf_update_feed_refresh_method(self, client, *args, **kwargs):
#		refresh = self.conf.get_string('/apps/penguintv/feed_refresh_method')
#		if refresh == 'auto':
#			self.set_feed_refresh_method(penguintv.REFRESH_AUTO)
#		else:
#			self.set_feed_refresh_method(penguintv.REFRESH_SPECIFIED)
