import ptvDB
import pycurl
import utils
import os, locale, gettext
import MediaManager

locale.setlocale(locale.LC_ALL, '')
gettext.install('penguintv', '/usr/share/locale')
gettext.bindtextdomain('penguintv', '/usr/share/locale')
gettext.textdomain('penguintv')
_=gettext.gettext

#Downloader API:
#constructor takes:  media, params, resume, queue, progress_callback, finished_callback
#  media:  the media dic
#  params: optional params, like for btdownloader
#  resume: are we supposed to resume?
#  queue:  are we supposed queue for playback when download is finished?  this variable is just passed around
#  progress_callback:  function to call for progress update.
#          arg of this is: (media, progress as 0 < x < 1, and text formatted message of progress)
#          the callback will return 1 if we should cancel download
#  finished_callback:  function to call when finished.
#          args is: (media, status, message)
#              where status is 0=failed, 1=success, 2=success and queue

class HTTPDownloader:
	"""Need a little internal class to keep track of callbacks from urllib.urlretrieve"""
	def __init__(self, media, params, resume, queue, progress_callback, finished_callback):
		#no params
		self.media = media
		self.progress_callback = progress_callback
		self.finished_callback = finished_callback
		self.resume = resume
		self.queue = queue
		
	def download(self,args):
		try:
			os.makedirs(os.path.dirname(self.media['file']))
		except OSError:
			pass
		try:
			if self.resume:
				try:
					fp = open(self.media['file'], "ab")
				except:
					fp = open(self.media['file'], "wb")
			else:
				fp = open(self.media['file'], "wb")
			curl = pycurl.Curl()
			curl.setopt(pycurl.URL, str(self.media['url'])) #cause it's unicode or some shit which is not a string or some junk
			curl.setopt(pycurl.FOLLOWLOCATION, 1)
			curl.setopt(pycurl.MAXREDIRS, 5)
			curl.setopt(pycurl.CONNECTTIMEOUT, 30)
			curl.setopt(pycurl.NOSIGNAL, 1)
			curl.setopt(pycurl.WRITEDATA, fp)
			curl.setopt(pycurl.PROGRESSFUNCTION, self.wrap_progress_callback)
			curl.setopt(pycurl.NOPROGRESS, 0)
			curl.setopt(pycurl.USERAGENT,'PenguinTV '+utils.VERSION)
			if self.resume:
				cursize = os.stat(self.media['file'])[6]
				curl.setopt(pycurl.RESUME_FROM_LARGE, cursize)
			curl.perform()
			curl.close()
			fp.close()
			if self.queue:
				self.finished_callback((self.media, MediaManager.FINISHED_AND_PLAY,_("finished downloading %s") % self.media['file']))
			self.finished_callback((self.media, MediaManager.FINISHED,_("finished downloading %s") % self.media['file']))
		except Exception, data: #this can happen if we cancelled the download
			if data[0]==33: #if server doesn't support resuming, retry
				self.resume=False
				self.download()
			if data[0]==42:
				self.finished_callback((self.media,MediaManager.STOPPED,None))
			else:
				print "some downloading error "+str(data)
				self.media['errormsg']=data
				self.finished_callback((self.media,MediaManager.FAILURE,data))
		
	def wrap_progress_callback(self, dl_total, dl_now, ul_total, ul_now):
		try:
			progress = int((dl_now*100.0)/dl_total)
		except:
			progress = 0
		if self.media.has_key('size')==False:
			self.media['size']=dl_total
			db = ptvDB.ptvDB()
			db.set_media_size(self.media['media_id'],self.media['size'])
		if self.media['size']==0:
			self.media['size']=dl_total
			db = ptvDB.ptvDB()
			db.set_media_size(self.media['media_id'],self.media['size'])
		d = { 'progress': str(progress),
			  'size': utils.format_size(self.media['size'])}
		result = self.progress_callback((self.media,progress,"Downloaded %(progress)s%% of %(size)s" % d))
		return result
		
