import gtkhtml2
import gtkmozembed
import gobject
import gtk
import ptvDB
import penguintv
import SimpleImageCache
import utils
import time
import os

import locale
import gettext

locale.setlocale(locale.LC_ALL, '')
gettext.install('penguintv', '/usr/share/locale')
gettext.bindtextdomain('penguintv', '/usr/share/locale')
gettext.textdomain('penguintv')
_=gettext.gettext

GTKHTML=0
MOZILLA=1
RENDERRER = GTKHTML

superglobal=utils.SuperGlobal()

class EntryView:
	def __init__(self, widget_tree, app):
		self._app = app
		scrolled_window = widget_tree.get_widget('html_scrolled_window')
		if RENDERRER==GTKHTML:
			htmlview = gtkhtml2.View()
			self._document = gtkhtml2.Document()
			self._document.connect("link-clicked", self.link_clicked)
			htmlview.connect("on_url", self.on_url)
			self._document.connect("request-url", self.request_url)
			htmlview.get_vadjustment().set_value(0)
			htmlview.get_hadjustment().set_value(0)
			scrolled_window.set_hadjustment(htmlview.get_hadjustment())
			scrolled_window.set_vadjustment(htmlview.get_vadjustment())
			self._document.clear()
			htmlview.set_document(self._document)
			scrolled_window.add(htmlview)
			self._htmlview = htmlview
		elif RENDERRER==MOZILLA:
			self.moz = gtkmozembed.MozEmbed()
			self.moz.connect("open-uri", self.moz_link_clicked)
			self.moz.load_url("about:blank")
			self.moz.get_location()
			scrolled_window.add_with_viewport(self.moz)
		scrolled_window.show_all()
		self._scrolled_window = scrolled_window
		
		self.current_entry={}
		self.currently_blank=False
		self.current_scroll_v = scrolled_window.get_vadjustment().get_value()
		self.current_scroll_h = scrolled_window.get_hadjustment().get_value()
		self.updater_timer=0
		self.image_cache = SimpleImageCache.SimpleImageCache()
		self.custom_entry = False
		
	def on_url(self, view, url):
		if url == None:
			url = ""
		self._app.display_status_message(url)
		return

	def link_clicked(self, document, link):
		link = link.strip()
		self._app.activate_link(link)
		return
		
	def moz_link_clicked(self, mozembed, uri):
		#WAIT:  gtkmozembed is returning the wrong type -- coming out as a pointer, should be string
		#wait for fixes
		print uri
		#link = link.strip()
		#self._app.activate_link(link)
		return True

	def request_url(self, document, url, stream):
		try:
			self._app.set_wait_cursor(True)
			#this was an experiment in threaded image loading.  What happened is the stream would be closed
			#when this function exited, so by the time the image downloaded the stream was invalid
			#self.image_cache.get_image(self.current_entry['entry_id'], url, stream)
			stream.write(self.image_cache.get_image(url))
			stream.close()
			self._app.set_wait_cursor(False)
		except Exception, ex:
			self._app.set_wait_cursor(False)
			stream.close()
			raise
	
	def update_progress(self, args):#(item, progress)):
		item,progress,message=args
		try:
			if len(self.current_entry) == 0:
				return
		except:
			return
		if item['entry_id'] != self.current_entry['entry_id'] or self.currently_blank==True:
			return
			
		for medium in self.current_entry['media']:
			if medium['media_id'] == item['media_id']:
				medium['progress']=progress
				medium['progress_message']=message
		if self.updater_timer==0:
			self.updater_timer=1
			self.updater_entry_id = item['entry_id']
			gobject.timeout_add(2000, self.update_display)
    		
	def update_display(self):
		try:
			if self.updater_entry_id != self.current_entry['entry_id'] or self.currently_blank == True:
				self.updater_timer=0
				self.updater_entry_id=-1
				return False
		except:
			self.updater_timer=0
			return False
		for medium in self.current_entry['media']:
			if medium.has_key('download_status'):
				if medium['download_status']==1:
					try:							
						if medium['progress']>=100:
							self.updater_timer=0
							self.updater_entry_id=-1
							continue
					except:
						continue	
					#if anything is not 100% and is downloading, we redraw and return
					self.display_item(self.current_entry)
					return True
		#nothing was < 100% and downloading
		self.updater_timer=0
		self.updater_entry_id=-1
		return False
		
	def get_scroll_vals(self):
		return (va.get_value(), ha.get_value())
		
	def set_scroll_vals(self, info):
		va.set_value(info[0])
		ha.get_value(info[1])
			  		
	def display_item(self, item=None):
		va = self._scrolled_window.get_vadjustment()
		ha = self._scrolled_window.get_hadjustment()
		rescroll=0
		
		#when a feed is refreshed, the item selection changes from an entry,
		#to blank, and to the entry again.  We used to lose scroll position because of this.
		#Now, scroll position is saved when a blank entry is displayed, and if the next
		#entry is the same id as before the blank, we restore those old values.
		#we have a bool to figure out if the current page is blank, in which case we shouldn't
		#save its scroll values.
		if item:
			try:
				if item['entry_id'] == self.current_entry['entry_id']:
					if self.currently_blank == False:
						self.current_scroll_v = va.get_value()
						self.current_scroll_h = ha.get_value()
					rescroll=1
			except:
				pass
			self.current_entry = item	
			self.currently_blank = False
		else:
			self.currently_blank = True
			self.current_scroll_v = va.get_value()
			self.current_scroll_h = ha.get_value()	
		
		if RENDERRER==GTKHTML:
			self._document.clear()
			self._document.open_stream("text/html")
		elif RENDERRER==MOZILLA:
			self.moz.open_stream("http://ywwg.com","text/html")
		enc = None
		#FIXME: how to get gnome defaul font styles for moz?
		if item is not None:
			html = (
            """<html><head>
            <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
            <style type="text/css">
            q { font-style: italic;}
            blockquote { display: block; font-style: italic; }
            .stitle {background-color:transparent;font-size:small;font-weight:bold;}
            .sdate {font-size:small}
            .content {padding-left:10px;margin-top:10px;}
            .media {background-color:#EEEEEE; border-color:#000000; border-width:2px; border-style: solid; padding:5px; margin:5px; }
            </style>
            <title>title</title></head><body>""" +
                self.htmlify_item(item) +
                "</body></html>")
		else:
			#html="""<html><body background="http://mit.edu/sts/images/zakim-web.gif"></body></html>"""
			html="""<html><body></body></html>"""
		
		html = html.encode('utf-8')
		if RENDERRER == GTKHTML:
			self._document.write_stream(html)
			self._document.close_stream()
		elif RENDERRER == MOZILLA:
			self.moz.append_data(html, long(len(html)))
			self.moz.close_stream()
		
		if rescroll==1:
			va.set_value(self.current_scroll_v)
			ha.set_value(self.current_scroll_h)
		else:
			va.set_value(va.lower)
			ha.set_value(ha.lower)
		return

	def display_custom_entry(self, message):
		if RENDERRER==GTKHTML:
			self._document.clear()
			self._document.open_stream("text/html")
			self._document.write_stream(message)
			self._document.close_stream()
		elif RENDERRER==MOZILLA:
			self.moz.open_stream("http://ywwg.com","text/html")
			self.moz.append_data(message, long(len(message)))
			self.moz.close_stream()		
		#self.scrolled_window.hide()
		self.custom_entry = True
		return
		
	def undisplay_custom_entry(self):
		if self.custom_entry:
			message = "<html></html>"
			if RENDERRER==GTKHTML:
				self._document.clear()
				self._document.open_stream("text/html")
				self._document.write_stream(message)
				self._document.close_stream()
			elif RENDERRER==MOZILLA:
				self.moz.open_stream("http://ywwg.com","text/html")
				self.moz.append_data(message, long(len(message)))
				self.moz.close_stream()	
			self.custom_entry = False

	def htmlify_item(self, item):
		""" Take an item as returned from ptvDB and turn it into an HTML page.  Very messy at times,
		    but there are lots of alternate designs depending on the status of media. """
	
		#global download_status
		ret = []
		if item.has_key('title'):
			ret.append('<div class="stitle">%s</div>' % item['title'])
		if item.has_key('creator'):
			if item['creator']!="" and item['creator'] is not None:
				ret.append('<p>By %s</p>' % (item['creator'],))			
		if item['date'] != (0,0,0,0,0,0,0,0,0):
			ret.append('<font size="3">%s</font><br/>' % time.strftime('%a %b %d, %Y %X',time.localtime(item['date'])))
   	
		if item.has_key('media'):
			ret.append('<div class="media">')
			for medium in item['media']:
				if medium['download_status']==0:     #not downloaded
					ret.append('<p>'+utils.html_command('download:',medium['media_id'])+' '+
									 utils.html_command('downloadqueue:',medium['media_id'])+
							         ' (%s)</p>' % (utils.format_size(medium['size'],)))
				elif medium['download_status'] == 1: #downloading		
					if medium.has_key('progress_message'): #downloading and we have a custom message
						ret.append('<p><i>'+medium['progress_message']+'</i> '+
						                    utils.html_command('pause:',medium['media_id'])+' '+
						                    utils.html_command('stop:',medium['media_id'])+'</p>')
					elif superglobal.download_status.has_key(medium['media_id']): #cached information
						status = superglobal.download_status[medium['media_id']]
						if status[0] == penguintv.DOWNLOAD_PROGRESS:
							d = {'progress':status[1],
							     'size':utils.format_size(medium['size'])}
							ret.append('<p><i>'+_("Downloading %(progress)d%% of %(size)s...") % d +'</i> '+
							            utils.html_command('pause:',medium['media_id'])+' '+
							            utils.html_command('stop:',medium['media_id'])+'</p>')
					elif medium.has_key('progress'):       #no custom message, but we have a progress value
						d = {'progress':medium['progress'],
						     'size':utils.format_size(medium['size'])}
						ret.append('<p><i>'+_("Downloading %(progress)d%% of %(size)s...") % d +'</i> '+
						            utils.html_command('pause:',medium['media_id'])+' '+
						            utils.html_command('stop:',medium['media_id'])+'</p>')
					else:                                  #no progress value to report
						ret.append('<p><i>'+_('Downloading %s...') % utils.format_size(medium['size'])+'</i> '+utils.html_command('pause:',medium['media_id'])+' '+
																  utils.html_command('stop:',medium['media_id'])+'</p>')
				elif medium['download_status'] == 2: #downloaded
					filename = medium['file'][medium['file'].rfind("/")+1:]

					if utils.is_known_media(medium['file']):
						if os.path.isdir(medium['file']) and medium['file'][-1]!='/':
							medium['file']=medium['file']+'/'
						ret.append('<p>'+utils.html_command('play:',medium['media_id'])+' '+
										 utils.html_command('redownload',medium['media_id'])+' '+
										 utils.html_command('delete:',medium['media_id'])+' <br/><font size="3">(<a href="reveal://%s">%s</a>: %s)</font></p>' % (medium['file'],filename,utils.format_size(medium['size'])))
					elif os.path.isdir(medium['file']):
						ret.append('<p>'+utils.html_command('file://',medium['file'])+' '+
									     utils.html_command('redownload',medium['media_id'])+' '+
									     utils.html_command('delete:',medium['media_id'])+'</p>')
					else:
						ret.append('<p>'+utils.html_command('file://',medium['file'])+' '+
										 utils.html_command('redownload',medium['media_id'])+' '+
										 utils.html_command('delete:',medium['media_id'])+' <br/> <font size="3">(<a href="reveal://%s">%s</a>: %s)</font></p>' % (medium['file'], filename, utils.format_size(medium['size'])))
				elif medium['download_status'] == 3: #resumable
					ret.append('<p>'+utils.html_command('resume:',medium['media_id'])+' '+
									 utils.html_command('redownload',medium['media_id'])+' '+
									 utils.html_command('delete:',medium['media_id'])+'(%s)</p>' % (utils.format_size(medium['size']),))	
				elif medium['download_status'] == -1: #error
					if superglobal.download_status.has_key(medium['media_id']):
						error_msg = superglobal.download_status[medium['media_id']][1]
					else:
						error_msg = _("There was an error downloading the file.")
					ret.append('<p>'+medium['url'][medium['url'].rfind('/')+1:]+': '+error_msg+'  '+
											 utils.html_command('retry',medium['media_id'])+' '+
											 utils.html_command('tryresume:',medium['media_id'])+' '+
											 utils.html_command('cancel:',medium['media_id'])+'(%s)</p>' % (utils.format_size(medium['size']),))
			ret.append('</div>')
		ret.append('<div class="content">')
		if item.has_key('description'):
			ret.append('<br/>%s ' % item['description'])
		ret.append('</div>')
		if item.has_key('link'):
			ret.append('<br/><a href="'+item['link']+'">'+_("Full Entry...")+'</a><br />' )
		ret.append('</p>')
		return "".join(ret)

	def scroll_down(self):
		""" Old straw function, _still_ not used.  One day I might have "space reading" """
		va = self._scrolled_window.get_vadjustment()
		old_value = va.get_value()
		new_value = old_value + va.page_increment
		limit = va.upper - va.page_size
		if new_value > limit:
			new_value = limit
		va.set_value(new_value)
		return new_value > old_value
		
