import gtk
import ptvDB
import penguintv

import locale
import gettext

locale.setlocale(locale.LC_ALL, '')
gettext.install('penguintv', '/usr/share/locale')
gettext.bindtextdomain('penguintv', '/usr/share/locale')
gettext.textdomain('penguintv')
_=gettext.gettext

class EntryList:
	def __init__(self, widget_tree, app, db):
		self._widget = widget_tree.get_widget("entrylistview")
		self._app = app
		self.entrylist = gtk.ListStore(str, str, int, int, str) #title, markeduptitle, entry_id, index, icon
		self.db = db
		self.feed_id=None
		self.last_entry=None
		self.context_menu_activate=False
		self.context_event = None
		
		#build list view
		self._widget.set_model(self.entrylist)
		
		icon_renderer = gtk.CellRendererPixbuf()
		renderer = gtk.CellRendererText()
		self.vadjustment = widget_tree.get_widget("entry_scrolled_window").get_vadjustment()
		self.hadjustment = widget_tree.get_widget("entry_scrolled_window").get_hadjustment()
		column = gtk.TreeViewColumn('Entries')
		column.pack_start(icon_renderer, False)
		column.pack_start(renderer, True)
		column.set_attributes(icon_renderer, stock_id=4)
		column.set_attributes(renderer, markup=1)
		self._widget.columns_autosize()
		self._widget.append_column(column)
		
		#signals
		self._widget.get_selection().connect("changed", self.item_selection_changed)
		self._widget.connect("row-activated", self.on_row_activated)
		
	def populate_entries(self, args):#feed_id, index=-1):
		"""populate entries takes a tuple because it gets called by the command queuer.  This is my fault.
		   please educate me and tell me how to do variable arguments"""
		feed_id = args[0]
		index = args[1]
		self.feed_id = feed_id
		db_entrylist = self.db.get_entrylist(feed_id)
		selection = self._widget.get_selection()
		selected = 0
		if index==-1:
			selected,index = self.get_selected()
		self.entrylist.clear()
		
		i=-1
		for entry_id,title,date,new in db_entrylist:
			i=i+1	
			flag = self.db.get_entry_flags(entry_id)
			icon = self.get_icon(flag)
			markeduptitle = self.get_markedup_title(title, flag)
			self.entrylist.append([title, markeduptitle, entry_id, i, icon])
		self.vadjustment.set_value(0)
		self.hadjustment.set_value(0)
		if index>=0:
			selection.select_path((self.find_index_of_item(selected),))
		self._widget.columns_autosize()
		
	def get_icon(self, flag):
		""" This would be a nice place to drop in custom icons """
		if flag & ptvDB.F_ERROR == ptvDB.F_ERROR:
			return 'gtk-dialog-error'
		if flag & ptvDB.F_DOWNLOADING == ptvDB.F_DOWNLOADING:
			return 'gtk-execute'
		if flag & ptvDB.F_DOWNLOADED == ptvDB.F_DOWNLOADED:
			return 'gtk-harddisk'
		else:
			return 'gnome-stock-blank'
	
	def get_markedup_title(self, title, flag):
		if flag & ptvDB.F_UNVIEWED == ptvDB.F_UNVIEWED:
			title="<b>"+title+"</b>"
		if flag & ptvDB.F_MEDIA == ptvDB.F_MEDIA:
			title="<span color='Blue'>"+title+"</span>"
		return title
		
	def update_entry_list(self, entry_id=None):
		if entry_id is None:
			if self.last_entry is None:
				return
			entry_id = self.last_entry
		for entry in self.entrylist:
			if entry[2] == entry_id:
				flag = self.db.get_entry_flags(entry_id)
	 			entry[1] = self.get_markedup_title(entry[0],flag)
	 			entry[4] = self.get_icon(flag) 
	 	#always update the selected entry, just in case.
	 	#this means the app updates the feeds and entries, but the 
	 	#entry list knows best when it comes to entries
		selection = self._widget.get_selection()
		selected,index = self.get_selected(selection)
		if selected:
			self._app.display_entry(selected, 0) #don't change read-state on this display, so if someone just marked this unread, it won't change right back 
		if entry_id == self.last_entry:
			return True
			
	def item_selection_changed(self, selection):
		selected,index = self.get_selected(selection) #then do something with it
		self.last_entry = selected
		#print "selected item: "+str(selected) #CONVENIENT
		if self.context_menu_activate:
			self.context_menu_activate = False
			self.do_context_menu()
			self.context_event = None
		if selected:
			self._app.display_entry(selected)
		else:
			self._app.display_entry(None)
			
	def get_selected(self, selection=None):
		if selection==None:
			s = self._widget.get_selection().get_selected()
		else:	
			s = selection.get_selected()
		if s:
			model, iter = s
			if iter is None:
				return (None,0)
			path = model.get_path(iter)
			index = path[0]
			return (model[index][2],model[index][3])
		else:
			return (None,0)
			
	def set_selected(self, entry_id):
		index = self.find_index_of_item(entry_id)
		self._widget.get_selection().select_path((index,))
		
	def clear_entries(self):
		self.entrylist.clear()
		
	def find_index_of_item(self, entry_id):
		i=0
		for entry in self.entrylist:
			if entry[2] == entry_id:
				return i
			i=i+1
		return -1
	
	def on_row_activated(self, treeview, path, view_column):
		index = path[0]
		model = treeview.get_model()
		item = self.db.get_entry(model[index][2])
		self._app.activate_link(item['link'])
		
	def selected_entry_has_media(self):
		if self.db.get_entry_flags(self.get_selected()[0]) & ptvDB.F_MEDIA:
			return True
		return False
		
	def prepare_context_menu(self, event):
		self.context_event = event
		self.context_menu_activate = True	
		if self.get_selected()[0] is not None:
			self.do_context_menu()
		
	def do_context_menu(self):
		try:
			menu = gtk.Menu()                                       
			if self.selected_entry_has_media():
				item = gtk.ImageMenuItem(_("_Download"))
				img = gtk.image_new_from_stock('gtk-go-down',gtk.ICON_SIZE_MENU)
				item.set_image(img)
				item.connect('activate',self._app.on_download_entry_activate)
				menu.append(item)
				
				item = gtk.ImageMenuItem('gtk-media-play')
				item.connect('activate',self._app.on_play_entry_activate)
				menu.append(item)
				
				item = gtk.MenuItem(_("Delete"))
				item.connect('activate',self._app.on_delete_entry_media_activate)
				menu.append(item)
			
			item = gtk.MenuItem(_("Mark as _Unviewed"))
			item.connect('activate',self._app.on_mark_entry_as_unviewed_activate)
			menu.append(item)
			
			menu.show_all()
			menu.popup(None,None,None, self.context_event.button,self.context_event.time)
		except:
			pass
