# Written by Owen Williams
# see LICENSE for license information
import os,sys,time
import string
import fnmatch
import locale, gettext
import gnomevfs

locale.setlocale(locale.LC_ALL, '')
gettext.install('penguintv', '/usr/share/locale')
gettext.bindtextdomain('penguintv', '/usr/share/locale')
gettext.textdomain('penguintv')
_=gettext.gettext


VERSION="1.51"

def format_size(size):
	if size > 1000000000:
		return str(size/1000000000)+" GB"
	elif size > 1000000:
		return str(size/1000000)+ " MB"
	elif size > 1000:
		return str(size/1000)+" KB"
	else:
		return str(size)+" bytes"
		
def GetPrefix():
	h, t = os.path.split(os.path.split(os.path.abspath(sys.argv[0]))[0])
	return h

def hours(n):  #this func copyright Bram Cohen
    if n == -1:
        return '<unknown>'
    if n == 0:
        return _('complete!')
    n = long(n)
    h, r = divmod(n, 60 * 60)
    m, sec = divmod(r, 60)
    if h > 1000000:
        return '<unknown>'
    if h > 0:
        return '%d:%02d:%02d' % (h, m, sec)
    else:
        return '%d:%02d' % (m, sec)

def is_known_media(filename):
	if os.path.isdir(filename):
		for root,dirs,files in os.walk(filename):
			for f in files:
				try:
					handler = gnomevfs.mime_get_default_application(gnomevfs.get_mime_type(f))
					if handler is not None:
						return True
				except:
					pass
		return False
	
	handler = gnomevfs.mime_get_default_application(gnomevfs.get_mime_type(filename))	
	if handler is not None:
		return True
	return False
	
def get_play_command_for(filename):
	known_players={ 'totem':'--enqueue',
					'xine':'--enqueue',
					'mplayer': '-enqueue',
					'banshee': '--enqueue'}
						
	try:
		full_qual_prog = gnomevfs.mime_get_default_application(gnomevfs.get_mime_type(filename))[2]
	except:
		print "error playing file "+str(filename)
		return "echo" # :)
	try:
		path, program = os.path.split(full_qual_prog)
	except:
		program = full_qual_prog
	
	if known_players.has_key(program):
		return full_qual_prog+" "+known_players[program]
	return full_qual_prog
				
def get_dated_dir():
	today = time.strftime("%Y-%m-%d")
	return today				
			
#http://www.faqts.com/knowledge_base/view.phtml/aid/2682
class GlobDirectoryWalker:
    # a forward iterator that traverses a directory tree

    def __init__(self, directory, pattern="*"):
        self.stack = [directory]
        self.pattern = pattern
        self.files = []
        self.index = 0

    def __getitem__(self, index):
        while 1:
            try:
                file = self.files[self.index]
                self.index = self.index + 1
            except IndexError:
                # pop next directory from stack
                self.directory = self.stack.pop()
                self.files = os.listdir(self.directory)
                self.index = 0
            else:
                # got a filename
                fullname = os.path.join(self.directory, file)
                if os.path.isdir(fullname) and not os.path.islink(fullname):
                    self.stack.append(fullname)
                if fnmatch.fnmatch(file, self.pattern):
                    return fullname
#usage:
#for file in GlobDirectoryWalker(".", "*.py"):
#    print file

def deltree(path):
#adapted and corrected from: http://aspn.activestate.com/ASPN/docs/ActivePython/2.2/PyWin32/Recursive_directory_deletes_and_special_files.html
	for file in os.listdir(path):
		file_or_dir = os.path.join(path,file)
		if os.path.isdir(file_or_dir) and not os.path.islink(file_or_dir):
			deltree(file_or_dir) #it's a directory reucursive call to function again
		else:
			os.remove(file_or_dir) #it's a file, delete it
	os.rmdir(path) #delete the directory here
	
	
#http://aspn.activestate.com/ASPN/Cookbook/Python/Recipe/82465
def _mkdir(newdir):
	"""works the way a good mkdir should :)
        - already exists, silently complete
        - regular file in the way, raise an exception
        - parent directory(ies) does not exist, make them as well
    """
	if os.path.isdir(newdir):
		pass
	elif os.path.isfile(newdir):
		raise OSError("a file with the same name as the desired " \
					  "dir, '%s', already exists." % newdir)
	else:
		head, tail = os.path.split(newdir)
		if head and not os.path.isdir(head):
			_mkdir(head)
		#print "_mkdir %s" % repr(newdir)
		if tail:
			os.mkdir(newdir)


def my_quote(str):
	"""Replaces some problematic characters with html equivalent if necessary"""
	#right now just & to &amp;, but not &amp; to &amp;amp;
	#instead of doing this with logic, just "unquote" the amps and then requote them
	str=string.replace(str,"&amp;","&")
	str=string.replace(str,"&","&amp;")
	return str
	
def uniquer(seq, idfun=None):
	if not seq:
		return None
	if idfun is None:
		def idfun(x): return x
	seen = {}
	result = []
	for item in seq:
		marker = idfun(item)
		# in old Python versions:
		# if seen.has_key(marker)
		# but in new ones:
		if marker in seen: continue
		seen[marker] = 1
		result.append(item)
	return result
	
commands={	'play:':_("Play"),
			'download:':_("Download"),
			'downloadqueue:':_("Download And Play"),
			'pause:':_("Pause"),
			'cancel:':_("Cancel"),
			'file://':_("Open File"),
			'delete:':_("Delete"),
			'resume:':_("Resume"),
			'clear:':_("Cancel"),
			'stop:':_("Stop"),
			'tryresume:':("Try Resume")	}
	
def html_command(command,arg):
	"""returns something like '<a href="play:%s">Play</a>' for all the commands I have.
	Dictionary has keys of commands, and returns located strings"""
	
	#a couple special cases
	if command == "redownload":
		return '<a href="download:'+str(arg)+'">'+_("Re-Download")+"</a>"
		
	if command == "retry":
		return '<a href="download:'+str(arg)+'">'+_("Retry")+'</a>'
	
	return '<a href="'+command+str(arg)+'">'+commands[command]+'</a>'
	
#http://aspn.activestate.com/ASPN/Cookbook/Python/Recipe/457667
#I know this is very bad, but damn if it doesn't work
import __main__

class SuperGlobal:

    def __getattr__(self, name):
        return __main__.__dict__.get(name, None)
        
    def __setattr__(self, name, value):
        __main__.__dict__[name] = value
        
    def __delattr__(self, name):
        if __main__.__dict__.has_key(name):
            del  __main__.__dict__[name]
	
